% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhenAnoma.R
\name{PhenAnoma}
\alias{PhenAnoma}
\title{PhenAnoma}
\usage{
PhenAnoma(x, dates, h, refp, anop, rge)
}
\arguments{
\item{x}{Numeric vector with greenness values}

\item{dates}{Vector with dates at which the greenness values were recorded}

\item{h}{Numeric. Indicates the geographic hemisphere to define the starting date of the growing season. h=1 if the vegetation is in the Northern Hemisphere (season starting at January 1st), h=2 if it is in the Southern Hemisphere (season starting at July 1st)}

\item{refp}{Numeric vector with the correlative number of dates to be used as reference period. For example, refp=c(1:393) for MODIS Vegetation Index 16-days composites (18/02/2000 – 06/06/2017)}

\item{anop}{Numeric vector with the correlative number of dates for the period in which the anomalies will be calculated. For example refp=c(21:43) for the first complete year for MODIS Vegetation Index 16-days composites (01/01/2001 – 19/12/2001). anop y refp can be overlapped}

\item{rge}{A vector containing minimum and maximum values of the response variable used in the analysis. We suggest the use of theoretically based limits. For example in the case of MODIS NDVI or EVI, it ranges from 0 to 10,000, so rge =c(0,10000)}
}
\value{
A numeric vector of length = nGS, where each value represents the expected greeness at that date
}
\description{
Calculates anomalies with respect to the regular phenological cycle using time series (numeric vector) of vegetation greenness.
}
\details{
Calculates phenological anomalies using a numeric vector of vegetation canopy greenness values (e.g. Leaf Area Index, LAI) or satellite based greenness proxies such as the Normalized Difference Vegetation Index (NDVI) or Enhanced Vegetation Index (EVI). For this purpose, it divides the time series (numeric vector) of vegetation greeness into 2: the reference period, from which the annual phenological cycle is calculated (same as Phen function), and the observation period, for which we want to calculate anomalies with respect to the annual phenological cycle. Negative anomalies correspond to observed values lower than the reference and positive anomalies to values higher than the reference.
}
\examples{
\dontshow{
## Testing function with time series of Slovenian data (EVI)

# Load data
phents<-read.table(system.file("extdata/date_tables/datats",package="npphen"),dec='.',
sep='\\t',header=TRUE)

# Anomaly of the phenology for the given data

PhenAnoma(x=as.vector(phents$x),dates=phents$dates,h=1,refp=c(1:150),
anop=c(128:150), rge=c(0,10000))
}

\donttest{
library(rts)
library(lubridate)

## Testing North Hemisphere data. Raster data from Slovenia (EVI index), h=1 ##

# Load data
sl.path<-system.file("extdata/HN_slovenia",package="npphen")
sl_rasters<-list.files(path=sl.path, pattern=glob2rx("slovenia*.tif"), full.names=TRUE)
Slovenia_rasters<-stack(sl_rasters)
sl_dates<-read.csv(system.file("extdata/date_tables/Slovenia_dates.csv", package="npphen"))
Slovenia_dates <- as.Date(sl_dates$date, format='\%d/\%m/\%Y')

# Generate a Raster time series using a raster stack and a date database from Slovenia
sl_ts<-rts(Slovenia_rasters,Slovenia_dates)

# Obtain data from a particular pixel generating a time series
sl_pixel<-cellFromXY(sl_ts,c(474368,5096979))
sl_pixelts<-extract(sl_ts,sl_pixel)
plot(sl_pixelts)

# Calculating the anomalies for the last growing season [343:365], refp [1:342]
# In this case refp and anop do not overlap
PhenAnoma(x=as.vector(sl_pixelts),dates=Slovenia_dates,h=1,refp=c(1:342),
anop=c(343:365), rge=c(0,10000))


## Testing South Hemisphere data. Raster data from Chile (EVI index), h=2 ##

# Load data
ay.path<-system.file("extdata/HS_aysen",package="npphen")
ayrasters<-list.files(path=ay.path, pattern=glob2rx("aysen*.tif"), full.names=TRUE)
Aysen_rasters<-stack(ayrasters)
ay_dates<-read.csv(system.file("extdata/date_tables/Aysen_dates.csv", package="npphen"))
Aysen_dates <- as.Date(ay_dates$date, format='\%d/\%m/\%Y')

# Generate a Raster time series using a raster stack and a date database from Aysen
ay_ts<-rts(Aysen_rasters,Aysen_dates)

# Obtain data from a particular pixel generating a time series
ay_pixel<-cellFromXY(ay_ts,c(228373,4806975))
ay_pixelts<-extract(ay_ts,ay_pixel)
plot(ay_pixelts)

# Anomaly for the period [309:331], reference period [1:354]. In this case, ref and anop overlaps
PhenAnoma(x=as.vector(ay_pixelts),dates=Aysen_dates,h=2,refp=c(1:354),
anop=c(309:331), rge=c(0,10000))
}
}
\seealso{
\code{\link{PhenAnoMap}}
}
