% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAncestors.R
\name{getAncestors}
\alias{getAncestors}
\title{Recursively create a character vector of ancestors for an individual ID.}
\usage{
getAncestors(id, ptree)
}
\arguments{
\item{id}{character vector of length 1 having the ID of interest}

\item{ptree}{a list of lists forming a pedigree tree as constructed by
\code{createPedTree(ped)} where \code{ped} is a standard pedigree dataframe.}
}
\value{
A character vector of ancestors for an individual ID.
}
\description{
Part of Pedigree Sampling
From PedigreeSampling.R
2016-01-28
}
\details{
Contains functions to build pedigrees from sub-samples
of genotyped individuals.

The goal of sampling is to reduce the number of inbreeding
loops in the resulting pedigree, and thus, reduce the
amount of time required to perform calculations with
SIMWALK2 or similar programs.
}
\examples{
\donttest{
library(nprcgenekeepr)
ped <- nprcgenekeepr::qcPed
ped <- qcStudbook(ped, minParentAge = 0)
pedTree <- createPedTree(ped)
pedLoops <- findLoops(pedTree)
ids <- names(pedTree)
allAncestors <- list()

for (i in seq_along(ids)) {
  id <- ids[[i]]
  anc <- getAncestors(id, pedTree)
  allAncestors[[id]] <- anc
}
head(allAncestors)
countOfAncestors <- unlist(lapply(allAncestors, length))
idsWithMostAncestors <-
  names(allAncestors)[countOfAncestors == max(countOfAncestors)]
allAncestors[idsWithMostAncestors]
}

}
