% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertRelationships.R
\name{convertRelationships}
\alias{convertRelationships}
\title{Converts pairwise kinship values to a relationship category descriptor.}
\usage{
convertRelationships(kmat, ped, ids = NULL, updateProgress = NULL)
}
\arguments{
\item{kmat}{a numeric matrix of pairwise kinship coefficients.
Rows and columns should be named with IDs.}

\item{ped}{the pedigree information in datatable format with required
colnames \code{id}, \code{sire}, and \code{dam}.}

\item{ids}{character vector of IDs or NULL to which the analysis should be
restricted. If provided, only relationships between these IDs will be
converted to relationships.}

\item{updateProgress}{function or NULL. If this function is defined, it
will be called during each iteration to update a
\code{shiny::Progress} object.}
}
\value{
A dataframe with columns \code{id1}, \code{id2}, \code{kinship},
\code{relation}. It is a long-form table of pairwise kinships, with
relationship categories included for each pair.
}
\description{
Part of Relations
}
\examples{
\donttest{
library(nprcgenekeepr)
ped <- nprcgenekeepr::smallPed
kmat <- kinship(ped$id, ped$sire, ped$dam, ped$gen, sparse = FALSE)
ids <- c("A", "B", "D", "E", "F", "G", "I", "J", "L", "M", "O", "P")
relIds <- convertRelationships(kmat, ped, ids)
rel <- convertRelationships(kmat, ped, updateProgress = function() {})
head(rel)
ped <- nprcgenekeepr::qcPed
bkmat <- kinship(ped$id, ped$sire, ped$dam, ped$gen,
                 sparse = FALSE)
relBIds <- convertRelationships(bkmat, ped, c("4LFS70", "DD1U77"))
relBIds
}

}
