% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOffspring.R
\name{findOffspring}
\alias{findOffspring}
\title{Finds the number of total offspring for each animal in the provided pedigree.}
\usage{
findOffspring(probands, ped)
}
\arguments{
\item{probands}{character vector of egos for which offspring should be
counted and returned.}

\item{ped}{the pedigree information in datatable format.  Pedigree
(req. fields: id, sire, dam, gen, population).
This requires complete pedigree information.}
}
\value{
A named vector containing the offspring counts for each animal in
\code{probands}. Rownames are set to the IDs from \code{probands}.
}
\description{
Part of Genetic Value Analysis
}
\examples{
\donttest{
library(nprcgenekeepr)
examplePedigree <- nprcgenekeepr::examplePedigree
breederPed <- qcStudbook(examplePedigree, minParentAge = 2,
                         reportChanges = FALSE,
                         reportErrors = FALSE)
focalAnimals <- breederPed$id[!(is.na(breederPed$sire) &
                                  is.na(breederPed$dam)) &
                                is.na(breederPed$exit)]
ped <- setPopulation(ped = breederPed, ids = focalAnimals)
trimmedPed <- trimPedigree(focalAnimals, breederPed)
probands <- ped$id[ped$population]
totalOffspring <- findOffspring(probands, ped)
}

}
