% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_skew_symmetric_matrix.R
\name{get_skew_symmetric_matrix}
\alias{get_skew_symmetric_matrix}
\title{Gets a 3-by-3 Skew Symmetric Matrix.}
\usage{
get_skew_symmetric_matrix(independent_components)
}
\arguments{
\item{independent_components}{A vector containing
the independent components of the matrix to get.}
}
\value{
The 3-by-3 skew symmetric matrix corresponding to
the specified independent components.
}
\description{
Returns the 3-by-3 skew symmetric matrix having the specified
independent components.
}
\details{
Given a vector of components, say  \eqn{[x,y,z]}, this function
will return matrix

\tabular{rrrrr}{
 \eqn{0} \tab \tab \eqn{-z} \tab \tab \eqn{y} \cr
 \eqn{z} \tab \tab \eqn{0}  \tab \tab \eqn{-x}\cr
\eqn{-y} \tab \tab \eqn{x}  \tab \tab \eqn{0}\cr}
}
\examples{
library(nprotreg)

# Define a vector of independent components.

independent_components <- cbind(1, 2, 3)

# Get the corresponding 3-by-3 skew symmetric matrix.

m <- get_skew_symmetric_matrix(independent_components)
}
\seealso{
\url{https://en.wikipedia.org/wiki/Skew-symmetric_matrix}.

Other Regression functions: \code{\link{cross_validate_concentration}},
  \code{\link{fit_regression}},
  \code{\link{get_equally_spaced_points}},
  \code{\link{simulate_regression}},
  \code{\link{simulate_rigid_regression}},
  \code{\link{weight_explanatory_points}}
}

