% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/np.den.R
\name{np.den}
\alias{np.den}
\alias{np.den-class}
\alias{np.den.default}
\alias{np.den.bin.den}
\alias{np.den.bin.data}
\alias{np.den.svar.bin}
\title{Local polynomial density estimation}
\usage{
np.den(x, ...)

\method{np.den}{default}(
  x,
  nbin = NULL,
  h = NULL,
  degree = 1 + as.numeric(drv),
  drv = FALSE,
  ncv = 0,
  ...
)

\method{np.den}{bin.den}(x, h = NULL, degree = 1 + as.numeric(drv), drv = FALSE, ncv = 0, ...)

\method{np.den}{bin.data}(x, h = NULL, degree = 1 + as.numeric(drv), drv = FALSE, ncv = 0, ...)

\method{np.den}{svar.bin}(x, h = NULL, degree = 1 + as.numeric(drv), drv = FALSE, ncv = 0, ...)
}
\arguments{
\item{x}{a (data) object used to select a method.}

\item{...}{further arguments passed to or from other methods.}

\item{nbin}{vector with the number of bins on each dimension.}

\item{h}{(full) bandwidth matrix (controls the degree of smoothing;
only the upper triangular part of h is used).}

\item{degree}{degree of the local polynomial used. Defaults to 1 (local linear estimation).}

\item{drv}{logical; if \code{TRUE}, the matrix of estimated first derivatives is returned.}

\item{ncv}{integer; determines the number of cells leaved out in each dimension.
Defaults to 0 (the full data is used) and it is not normally changed by the user
in this setting. See "Details" below.}
}
\value{
Returns an S3 object of class \code{np.den} (locpol den + bin den + grid par.). 
A \code{\link{bin.den}} object with the additional (some optional) 3 components:
\item{est}{vector or array (dimension \code{nbin}) with the local polynomial density estimates. }
\item{locpol}{a list with 6 components:
\itemize{
   \item{\code{degree} degree of the polinomial.}
   \item{\code{h} bandwidth matrix.}
   \item{\code{rm} residual mean (of the escaled bin counts).}
   \item{\code{rss} sum of squared residuals (of the escaled bin counts).}
   \item{\code{ncv} number of cells ignored (in each dimension).}
}}
\item{deriv}{(if requested) matrix of first derivatives.}
}
\description{
Estimates a multidimensional probability density function (and its first derivatives) 
using local polynomial kernel smoothing of linearly binned data.
}
\details{
Standard generic function with a default method (interface to the 
fortran routine \code{lp_data_grid}), in which argument \code{x} 
is a vector or matrix of covariates (e.g. spatial coordinates).
In this case, the data are binned (calls \code{\link{bin.den}}) and the local fitting
procedure is applied to the scaled bin counts (calls \code{\link{np.den.bin.den}}).

If parameter \code{nbim} is not specified is set to \code{rep(25, ncol(x))}. 

A multiplicative triweight kernel is used to compute the weights.

If \code{ncv > 1}, estimates are computed by leaving out cells with indexes within 
the intervals \eqn{[x_i - ncv + 1, x_i + ncv - 1]}, at each dimension i, where \eqn{x} 
denotes the index of the estimation position.
}
\examples{
bin.den <- binning(earthquakes[, c("lon", "lat")], nbin = c(30,30))
h.den <- h.cv(bin.den) 
den <- np.den(bin.den, h = h.den$h)
plot(den, main = 'Estimated log(density)')
}
\references{
Wand, M.P. and Jones, M.C. (1995) \emph{Kernel Smoothing}. Chapman and Hall, London.
}
\seealso{
\code{\link{bin.den}}, \code{\link{binning}}, \code{\link{h.cv}}, 
\code{\link{data.grid}}.
}
