% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsUnif.R
\name{Neutrosophic Uniform}
\alias{Neutrosophic Uniform}
\alias{dnsUnif}
\alias{pnsUnif}
\alias{qnsUnif}
\alias{rnsUnif}
\title{Neutrosophic Uniform Distribution}
\usage{
dnsUnif(x, min, max)

pnsUnif(q, min, max, lower.tail = TRUE)

qnsUnif(p, min, max)

rnsUnif(n, min, max)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{min}{lower limits of the distribution. Must be finite.}

\item{max}{upper limits of the distribution. Must be finite.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \leq x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{dnsUnif} gives the density function

 \code{pnsUnif} gives the distribution function

 \code{qnsUnif} gives the quantile function

 \code{rnsUnif} generates random variables from the neutrosophic Uniform Distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic Uniform distribution of a continuous
variable \eqn{X} with parameters \eqn{a_N} and  \eqn{b_N}.
}
\details{
The neutrosophic Uniform distribution with parameters
\eqn{a_N} and \eqn{b_N} has the density
\deqn{f_N(x)=\frac{1}{b_N-a_N}}
for \eqn{a_N \in (a_L, a_U)}  lower parameter interval, \eqn{b_N \in (b_L,b_U)},
 upper parameter interval.
}
\examples{

dnsUnif(x = 1, min = c(0, 5), max = c(15, 20))
dnsUnif(x = c(6, 10), min = c(0, 5), max = c(15, 20))

punif(q = 1, min = c(0, 5), max = c(15, 20))
punif(q = c(6, 10), min = c(0, 5), max = c(15, 20))

qnsUnif(p = c(0.25, 0.5, 0.75), min = c(0, 5), max = c(15, 20))

rnsUnif(n = 10, min = c(0, 5), max = c(15, 20))

}
\references{
Alhabib, R., Ranna, M. M., Farah, H., & Salama, A. A. (2018). Some neutrosophic
probability distributions, \emph{Neutrosophic Sets and Systems}, 22, 30-38.
}
