% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_generation.R
\name{bm_compound_poisson_ghyp}
\alias{bm_compound_poisson_ghyp}
\title{Generates a (correlated) Brownian motion path with
correlated but unsynchronised GHYP jumps.}
\usage{
bm_compound_poisson_ghyp(n, sigma, ghyp_distr, n_jumps, delta_time)
}
\arguments{
\item{n}{Length of the path}

\item{sigma}{Correlation matrix for the Brownian part.}

\item{ghyp_distr}{GHYP distribution (\code{ghyp::ghyp}).}

\item{n_jumps}{Number of jumps.}

\item{delta_time}{Time step.}
}
\value{
A BM path with Correlated Gaussian jumps
}
\description{
Generates a (correlated) Brownian motion path with
correlated but unsynchronised GHYP jumps.
}
\examples{
n <- 1000
d <- 3
sigma <- matrix(c(1.0, 0.2, 0.2, 0.2, 1.0, 0.2, 0.2, 0.2, 1.0), 3, 3)
jump_sigma <- sigma
n_jumps <- 50
delta_time <- 0.5
ghyp_distr <- ghyp::ghyp(mu = rep(0, d))
bm_compound_poisson_ghyp(n, sigma, ghyp_distr, n_jumps, delta_time)
}
