% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clean_data}
\alias{clean_data}
\title{Clean data using STL / Loess function.}
\usage{
clean_data(data, frequency = 24, s_window = 24, t_window = 24, ...)
}
\arguments{
\item{data}{Data to clean.}

\item{frequency}{Time series frequency of observations}

\item{s_window}{Seasonal window.}

\item{t_window}{Trend window.}

\item{...}{additional inputs given to stats::stl}
}
\value{
List with the cleaned time series, the remainders
of the cleaning and their standard deviations.
}
\description{
Clean data using STL / Loess function.
}
\examples{
n <- 1000
d <- 3
delta_time <- 0.01
data <- matrix(
  rnorm(n = n * d, mean = 0, sd = sqrt(delta_time)),
  ncol = d
)
data <- apply(data, 2, cumsum)
clean_data(data)
}
