% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_doc.R
\docType{data}
\name{Locations2014}
\alias{Locations2014}
\title{General Election Voting Places 2014}
\format{A data frame with 2,568 rows and 9 variables.}
\source{
\url{http://www.electionresults.govt.nz/electionresults_2014/e9/html/statistics.html} for the voting place locations.
\url{http://www.stats.govt.nz/browse_for_stats/Maps_and_geography/Geographic-areas/digital-boundary-files.aspx} 
for the 2014 shapefiles for Regional Council, Territorial Authority, and Area Unit.  See
\url{https://github.com/ellisp/nzelect/tree/master/prep} for the code linking the two.
}
\usage{
Locations2014
}
\description{
Voting places for the New Zealand 2014 general election
}
\details{
\itemize{
  \item \code{ElectorateNumber}
  \item \code{ElectorateName}.  Name of electorate in which the voting place is 
  physically located.
  \item \code{VotingPlaceID}.
  \item \code{NZTM2000Northing}
  \item \code{NZTM2000Easting}
  \item \code{WGS84Latitude}
  \item \code{WGS84Longitude}
  \item \code{VotingPlace}.  Address of the VotingPlace.  Cross-references to
   \code{GE2014$VotingPlace}.
  \item \code{TA2014_NAM}.  Name of the Territorial Authority in which the voting 
  place is physically located.
  \item \code{REGC2014_n}.  Name of the Regional Council in which the voting place is physically located.
  \item \code{AU2014}.  Number of the Area Unit in which the voting place is physically located.
  \item \code{MB2014}.  Number of the Mesh Block in which the voting place is physically located.
}
}
\seealso{
\code{\link{GE2014}}
}
\keyword{datasets}

