% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_nzffd.R
\name{nzffd_clean}
\alias{nzffd_clean}
\title{Clean NZ freshwater Fish fishdasets}
\usage{
nzffd_clean(fishd)
}
\arguments{
\item{fishd}{A dataframe imported from the NZFFD using \code{nzffd_import}}
}
\value{
A dataframe of the same dimensions as \code{fishd}, but cleaned.
}
\description{
Clean up data imported from the NZ Freshwater Fish Database.
}
\details{
The first letter of all words in \code{catchname} and \code{locality} are 
capitalised and any non-alphanumeric characters are removed. \code{time} 
is converted to a standardised 24 hour format and nonsesical values 
converted to \code{NA}. \code{org} is converted to all lowercase and has
non-alphanumeric characters removed. \code{map} is converted to lower case
and has any non-three digit codes converted to \code{NA}. \code{catchname} 
codes are tidied following the suggested abbreviations (add URL), e.g.
\code{Cluth River}, \code{Clutha r} and \code{Clutha river} all 
become \code{Clutha R}. Finally a new variable \code{form} is added which
defines the sampled habitat type for each observation.
}
\examples{
\dontrun{

dat <- nzffd_clean(nzffdr::nzffd_data)

}
}
