% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{labbcat.getLayer}
\alias{labbcat.getLayer}
\title{Gets a layer definition.}
\usage{
labbcat.getLayer(labbcat, id)
}
\arguments{
\item{labbcat}{A LaBB-CAT instance object previously created by a call to labbcat.instance}

\item{id}{ID of the layer to get the definition for}
}
\value{
The definition of the given layer, with members:
\enumerate{
 \item{id The layer's unique ID}
 \item{parentId The layer's parent layer ID}
 \item{description The description of the layer}
 \item{alignment The layer's alignment - 0 for none, 1 for point alignment, 2 for interval alignment}
 \item{peers Whether children have peers or not}
 \item{peersOverlap Whether child peers can overlap or not}
 \item{parentIncludes Whether the parent t-includes the child}
 \item{saturated Whether children must temporally fill the entire parent duration (true) or not (false)}
 \item{parentIncludes Whether the parent t-includes the child}
 \item{type The type for labels on this layer}
 \item{validLabels List of valid label values for this layer}
}
}
\description{
Gets a layer definition.
}
\examples{
## Connect to LaBB-CAT
labbcat <- labbcat.instance("https://labbcat.canterbury.ac.nz/demo/", "demo", "demo")

## Get the definition of the orthography layer
orthography.layer <- labbcat.getLayer(labbcat, "orthography")

}
\seealso{
\code{\link{labbcat.getLayerIds}}
\code{\link{labbcat.getLayers}}
}
\keyword{layer}
