% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{labbcat.instance}
\alias{labbcat.instance}
\title{Connects to the given 'LaBB-CAT' instance, and returns and object that
must be used for all other functions.}
\usage{
labbcat.instance(url, username = NULL, password = NULL, timeout = 10)
}
\arguments{
\item{url}{URL to the LaBB-CAT instance}

\item{username}{The LaBB-CAT username, if it is password-protected}

\item{password}{The LaBB-CAT password, if it is password-protected}

\item{timeout}{Maximum time for any LaBB-CAT request}
}
\value{
An object that can be passed as the labbcat parameter for
    other functions in this package
}
\description{
If a username and password are not passed, and the 'LaBB-CAT' instance
is password-protected (and the function is called in interactive
mode), then the user will be prompted for the username and
password. This is the recommended method for accessing
password-protected 'LaBB-CAT' instances, in order to avoid saving
passwords in script files. The username and password parameters are
provided for cases where the script is not run in interactive mode.
}
\examples{
## connect to an open or password-protected instance of LaBB-CAT
labbcat <- labbcat.instance("https://labbcat.canterbury.ac.nz/demo/")

## connect to a password-protected instance of LaBB-CAT with explicit credentials
labbcat <- labbcat.instance("https://labbcat.canterbury.ac.nz/demo/",
     username="demo", password="demo")

}
\keyword{connect}
\keyword{password}
\keyword{timeout}
\keyword{username}
