% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_decomposed_data}
\alias{example_decomposed_data}
\title{Example Decomposed Data}
\format{
A list with three dataframes:
\describe{
\item{\code{longterm}}{A dataframe with long-term trend specific data}
\item{\code{midterm}}{A dataframe with mid-term seasonality specific data}
\item{\code{shortterm}}{A dataframe with short-term seasonality specific data}
}
\strong{Longterm Data Frame}:
\describe{
\item{\code{longterm.country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{longterm.year}}{The respective year.}
\item{\code{longterm.avg_hourly_demand}}{The average hourly electricity demand (in megawatts) for each year.}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
\strong{Midterm Data Frame}:
\describe{
\item{\code{midterm.country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{midterm.date}}{The date of the demand measurement (in \code{YYYY-MM-DD} format).}
\item{\code{midterm.year}}{The respective year.}
\item{\code{midterm.month}}{The respective month.}
\item{\code{midterm.day}}{The respective day.}
\item{\code{midterm.wday}}{The type of weekday (e.g., \code{Sun}, \code{Mon})}
\item{\code{midterm.avg_hourly_demand}}{The average hourly electricity demand (in megawatts) for each day.}
\item{\code{midterm.seasonal_avg_hourly_demand}}{The seasonal mid-term component of the demand (in megawatts).}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
\strong{Shortterm Data Frame}
\describe{
\item{\code{shortterm.country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{shortterm.date}}{The date of the demand measurement (in \verb{YYYY-MM-DD HH:MM:SS} format).}
\item{\code{shortterm.year}}{The respective year.}
\item{\code{shortterm.month}}{The respective month.}
\item{\code{shortterm.day}}{The respective day.}
\item{\code{shortterm.wday}}{The type of weekday (e.g., \code{Sun}, \code{Mon})}
\item{\code{shortterm.hour}}{The respective hour (from 0 to 23).}
\item{\code{shortterm.hourly_demand}}{The actual hourly electricity demand (in megawatts) for each hour.}
\item{\code{shortterm.hourly_demand_trend_corrected}}{The demand substracted by the long-term trend.}
\item{\code{shortterm.yearly}}{The yearly average electricity demand in the respective year.}
\item{\code{shortterm.daily}}{The daily average electricity demand in the respective day.}
\item{\code{shortterm.hourly_demand_trend_and_season_corrected}}{The short-term seasonal component which is the hourly demand, substracted by both the long-term trend and the mid-term seasonality.}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
}
\source{
Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/)
}
\usage{
example_decomposed_data
}
\description{
This dataset contains the decomposed data of \code{\link{example_demand_data_filled}} into a long-term trend, a mid-term seasonality, and a short-term seasonality. It contains a list of three dataframes, one for each component.
}
\keyword{dataset}
\keyword{decomposed}
