% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_full_model_predictions}
\alias{example_full_model_predictions}
\title{Example Full Model Predictions Data}
\format{
A data frame with 43800 rows and 12 columns:
\describe{
\item{\code{country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{date}}{The date (in \code{YYYY-MM-DD} format).}
\item{\code{year}}{The respective year.}
\item{\code{month}}{The respective month.}
\item{\code{day}}{The respective day.}
\item{\code{wday}}{The type of weekday (e.g., \code{Sun}, \code{Mon})}
\item{\code{hour}}{The respective hour of the day.}
\item{\code{hourly_demand}}{The actual hourly electricity demand (in megawatts).}
\item{\code{long_term_model}}{The predicted long-term trend (yearly average of hourly demand) from the best long-term forecasting model.}
\item{\code{mid_term_model}}{The predicted mid-term seasonality (daily minus yearly average of hourly demand) from the best mid-term forecasting model.}
\item{\code{short_term_model}}{The predicted short-term seasonality (actual hourly demand minus the long-term trend minus the mid-term seasonality) from the best short-term forecasting model.}
\item{\code{complete_model}}{Final predicted electricity demand for each hour. Derived by adding the results from the long-, mid-, and short-term components.}
}
}
\source{
demand data: Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/);
holidays: https://date.nager.at/api/v3/publicholidays/
}
\usage{
example_full_model_predictions
}
\description{
This dataset combines the results from \code{\link{long_term_lm}}, \code{\link{mid_term_lm}}, and \code{\link{short_term_lm}} into the final predictions of hourly electricity demand for France from 2017 until 2021.
}
\keyword{dataset}
\keyword{final-predictions}
