% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_entsoE_data.R
\name{get_entsoE_data}
\alias{get_entsoE_data}
\title{Load data from the ENTSO-E Transparency Platform}
\usage{
get_entsoE_data(
  start_year,
  end_year,
  country,
  api_key = "default",
  dry_run = FALSE
)
}
\arguments{
\item{start_year}{Numeric. The starting year for which load data will be requested.}

\item{end_year}{Numeric. The final year for which load data will be requested.}

\item{country}{Character. The country name for which load data will be requested provided as the English name of the country.}

\item{api_key}{Character. A valid API key for the ENTSO-E Transparency Platform. If set to "default", one of the deposited keys will be used.}

\item{dry_run}{Boolean. Defaults to FALSE. This is only set to TRUE for the example run.}
}
\value{
A Data Frame with the following columns
\describe{
\item{date}{The series of dates, POSIXct format.}
\item{load}{The series of load data, numeric}
\item{unit}{The series of units in which the load data is provided, character.}
\item{year}{The year of each load data point, numeric}
\item{time_interval}{The time resolution of each load data point, character}
\item{country}{The ISO2C Country Code, character}
}
}
\description{
This function makes various API requests to the Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/) and
stores the downloaded load data in a data frame. The earliest possible year for the requested load time series is 2017.
}
\examples{
example_demand_data <- get_entsoE_data(2017, 2021, "France", api_key = "default", dry_run = TRUE)
print(example_demand_data[1:20, ])

}
