% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/short_term_future.R
\name{short_term_future}
\alias{short_term_future}
\title{Generate future short-term demand predictions}
\usage{
short_term_future(
  shortterm_predictions,
  end_year,
  data_directory = tempdir(),
  model_list = NULL,
  verbose = FALSE
)
}
\arguments{
\item{shortterm_predictions}{Dataframe. Generated by \code{\link{short_term_lm}}}

\item{end_year}{Integer. Specifies the final year for which future predictions will be generated}

\item{data_directory}{The path to the directory where the data will be saved and where the function will look for
the short-term models from \code{\link{short_term_lm}}. The default is set to a temporary directory.}

\item{model_list}{A list with the models from \code{\link{short_term_lm}}. Only needs to be specified if the models
are not in the data directory.}

\item{verbose}{A boolean value indicating if you want the generated plots to be shown (set to TRUE if yes).}
}
\value{
The extended initial dataframe with the future predictions for the short term model.

A list with the extended initial dataframe with the future predictions for the short term model. And the plot with the shortterm seasonality future forecast.
The dataset and the plot are saved in the respective folder for the country.
\describe{
\item{shortterm_future_predictions}{A dataframe with the input and prediction data for the future short-term seasonality.}
\item{shortterm_future_plot}{A plot with the prediction results.}
}
}
\description{
This function extends the short-term demand predictions generated by \code{\link{short_term_lm}} until a specified future year.
The function also produces and saves visualizations of the actual and the predicted demand over the training, test, and future periods.
}
\examples{
example_shortterm_future_predictions <- short_term_future(example_shortterm_predictions,
  end_year = 2028
)
}
\seealso{
See also function \code{\link{long_term_future}} and \code{\link{mid_term_future}} for the other prediction models.
}
