% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_sets.R
\name{list_sets}
\alias{list_sets}
\title{List sets}
\usage{
list_sets(url = "http://api.gbif.org/v1/oai-pmh/registry",
  token = NULL, as = "df", ...)
}
\arguments{
\item{url}{(character) OAI-PMH base url. Defaults to the URL for
arXiv's OAI-PMH server (http://export.arxiv.org/oai2)
or GBIF's OAI-PMH server (http://api.gbif.org/v1/oai-pmh/registry)}

\item{token}{(character) a token previously provided by the server to
resume a request where it last left off}

\item{as}{(character) What to return. One of "df" (for data.frame; default),
"list", or "raw" (raw text)}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
List sets
}
\examples{
\dontrun{
# Get back a data.frame
list_sets()

# Get back a list
list_sets(as = "list")

# Get back raw text
list_sets(as = "raw")

# curl options
library("httr")
list_sets(config = verbose())
}
}
