% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{list_cond_L}
\alias{list_cond_L}
\title{Conditions for local assessment under certain budget and cost values.}
\usage{
list_cond_L(budget, lambda1, lambda2, fit, K = NULL)
}
\arguments{
\item{budget}{A numeric specifying the amount of budget. Use the currency
unit consistent with \code{lambda1} and \code{lambda2}.}

\item{lambda1}{A numeric specifying the cost per sequence read for
high-throughput sequencing. Use the currency unit consistent with \code{budget}
and \code{lambda2}.}

\item{lambda2}{A numeric specifying the cost per replicate for library
preparation. Use the currency unit consistent with \code{budget} and \code{lambda1}.}

\item{fit}{An \code{occumbFit} object.}

\item{K}{An optional vector for manually specifying the number of replicates.}
}
\value{
A data frame containing columns named \code{budget}, \code{lambda1}, \code{lambda2},
\code{K}, and \code{N}.
}
\description{
\code{list_cond_L()} constructs a list of possible local species
diversity assessment conditions under specified budget and cost values.
}
\details{
This function can generate a data frame object to be given to the
\code{settings} argument of \code{eval_util_L()}; see Examples of \code{eval_util_L()}.
By default, it outputs a list of all feasible combinations of values for the
number of replicates per site \code{K} and the sequencing depth per replicate
\code{N}, based on the given budget and cost values and the number of sites
(identified by reference to the \code{fit} object). The resulting \code{N} can be
non-integer because it is calculated simply by assuming that we can obtain
its maximum value. If you want to obtain a list for only a subset of the
possible \code{K} values under a given budget and cost values, use the \code{K}
argument to provide a vector of the desired \code{K} values.
}
