% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{app}
\alias{app}
\title{Get an instance of the interactive shiny occupation coding app.}
\usage{
app(
  questionnaire = questionnaire_web_survey(),
  app_settings = create_app_settings(save_to_file = TRUE),
  css_file = NULL,
  resource_dir = system.file("www", package = "occupationMeasurement"),
  ...
)
}
\arguments{
\item{questionnaire}{The questionnaire to load.
(Defaults to the questionnaire returned by \link{questionnaire_web_survey}().)}

\item{app_settings}{The app_settings to use. Check the documentation for
create_app_settings to learn about the options.}

\item{css_file}{Path to a CSS file to be included in the app.}

\item{resource_dir}{From which directory to static files e.g. styles.
If you want to load additional resources from outside the package, you
should rather do so with \link[shiny:resourcePaths]{shiny::addResourcePath} rather than with this
parameter.}

\item{...}{Any additional parameters will be forwarded to shiny::shinyApp().}
}
\value{
A shiny app instance.
}
\description{
Printing the returned instance or returning it without saving it in a
variable will start the app.
}
\examples{
\dontshow{data.table::setDTthreads(1)}

\dontrun{
app_instance <- app(
  app_settings = create_app_settings(
    # Important to save results from the app
    save_to_file = TRUE
  )
)

# Start the app
if (interactive()) {
  app_instance
}
}
}
\seealso{
\code{vignette("app")}, \code{\link[=questionnaire_web_survey]{questionnaire_web_survey()}}
}
