% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{methods}
\name{[[,oce-method}
\alias{[[,oce-method}
\title{Extract Something From an oce Object}
\usage{
\S4method{[[}{oce}(x, i, j, ...)
}
\arguments{
\item{x}{An oce object}

\item{i}{The item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}
}
\description{
The named item is sought first in
\code{metadata}, where an exact match to the name is required. If
it is not present in the \code{metadata} slot, then a partial-name
match is sought in the \code{data} slot.
}
\details{
To get information on the specialized variants of this function, 
type e.g. \code{?"[[,adv-method"} for information on extracting
data from an object of \code{\link{adv-class}}.
}
\examples{
data(ctd)
ctd[["longitude"]] # in metadata
head(ctd[["salinity"]]) # in data
data(section)
summary(section[["station", 1]])
}

