% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landsat.R
\name{landsatTrim}
\alias{landsatTrim}
\title{Trim a landsat Image to a Geographical Region}
\usage{
landsatTrim(x, ll, ur, box, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{A \code{landsat} object, e.g. as read by \code{\link{read.landsat}}.}

\item{ll}{A list containing \code{longitude} and \code{latitude}, for the
lower-left corner of the portion of the image to retain, or a vector
with first element longitude and second element latitude. If provided,
then \code{ur} must also be provided, but \code{box} cannot.}

\item{ur}{A list containing \code{longitude} and \code{latitude}, for the
upper-right corner of the portion of the image to retain, or a vector
with first element longitude and second element latitude. If provided,
then \code{ll} must also be provided, but \code{box} cannot.}

\item{box}{A list containing \code{x} and \code{y} (each of length 2),
corresponding to the values for \code{ll} and \code{ur}, such as would
be produced by a call to \code{locator(2)}. If provided, neither
\code{ll} nor \code{ur} may be provided.}

\item{debug}{A flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or a higher value for more debugging.}
}
\value{
An object of \code{\link{landsat-class}}, with data having
been trimmed approximately as specified.
}
\description{
Trim a landsat image to a latitude-longitude box. This is only an approximate
operation, because landsat images are provided in x-y coordinates, not
longitude-latitude coordinates.
}
\details{
As of June 25, 2015, the matrices storing the image data are trimmed to indices
determined by linear interpolation based on the location of the \code{ll} and
\code{ur} corners within the lon-lat corners specified in the image data. (A
previous version trimmed in UTM space, and in fact this may be done in future
also, if a problem in lonlat/utm conversion is resolved.) An error results if
there is no intersection between the trimming box and the image box.
}
\seealso{
The documentation for \code{\link{landsat-class}} explains the
structure of landsat objects, and also outlines the other functions dealing
with them.

Other things related to \code{landsat} data: \code{\link{[[,landsat-method}},
  \code{\link{[[<-,landsat-method}},
  \code{\link{landsat-class}}, \code{\link{landsatAdd}},
  \code{\link{landsat}}, \code{\link{plot,landsat-method}},
  \code{\link{read.landsat}},
  \code{\link{summary,landsat-method}}
}
\author{
Dan Kelley and Clark Richards
}
\concept{satellite}
\concept{things related to \code{landsat} data}
