% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsk.R
\docType{class}
\name{rsk-class}
\alias{rsk-class}
\title{Class to Store Rsk Data}
\description{
This class stores ``Ruskin'' data, from RBR [1].
}
\details{
A \code{rsk} object may be read with \code{\link{read.rsk}} or created with
\code{\link{as.rsk}}.  Plots can be made with \code{\link{plot,rsk-method}}, while
\code{\link{summary,rsk-method}} produces statistical summaries and \code{show}
produces overviews.   If atmospheric pressure has not been removed from the
data, the functions \code{\link{rskPatm}} may provide guidance as to its value;
however, this last function is no equal to decent record-keeping at sea.
}
\section{Slots}{

\describe{
\item{\code{data}}{As with all \code{oce} objects, the \code{data} slot
for \code{rsk} objects is a
\code{\link{list}} containing the main data for the object.
{}}

\item{\code{metadata}}{As with all \code{oce} objects, the \code{metadata} slot
for \code{rsk} objects is a \code{\link{list}} containing
information about the \code{data} or about the object itself.
{}}

\item{\code{processingLog}}{As with all \code{oce} objects, the \code{processingLog} slot
for \code{rsk} objects is a
\code{\link{list}} with entries describing the creation and evolution
of the object. The contents are updated by various \code{oce} functions to
keep a record of processing steps.  Object summaries and
\code{\link{processingLogShow}} both display the log.}
}}

\section{Modifying slot contents}{


Although the \code{[[<-} operator may permit modification of the contents
of \code{rsk} objects (see \code{\link{[[<-,rsk-method}}),
it is better to use \code{\link{oceSetData}}
and \code{\link{oceSetMetadata}}, because that will save an entry
in the \code{processingLog} to describe the change.
}

\section{Retrieving slot contents}{


The full contents of the \code{data} and \code{metadata} slots of a \code{rsk}
object named \code{rsk} may be retrieved in the standard R way. For example,
\code{slot(rsk, "data")} and \code{slot(rsk, "metadata")} return
the \code{data} and \code{metadata} slots, respectively. The
\code{\link{[[,rsk-method}} operator can also be used to access slots,
with \code{rsk[["data"]]} and \code{rsk[["metadata"]]}, respectively.
Furthermore, \code{\link{[[,rsk-method}} can be used to retrieve
named items (and potentially some derived items) within the
\code{metadata} and \code{data} slots, the former taking precedence
over the latter in the lookup. It is also possible
to find items more directly, using \code{\link{oceGetData}} and
\code{\link{oceGetMetadata}}, but this cannot retrieve derived items.
}

\references{
1. \href{https://www.rbr-global.com/products}{RBR website: www.rbr-global.com/products}
}
\seealso{
Other classes provided by oce: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{odf-class}}, \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to rsk data: \code{\link{[[,rsk-method}},
  \code{\link{[[<-,rsk-method}}, \code{\link{as.rsk}},
  \code{\link{plot,rsk-method}}, \code{\link{read.rsk}},
  \code{\link{rskPatm}}, \code{\link{rskToc}},
  \code{\link{rsk}}, \code{\link{subset,rsk-method}},
  \code{\link{summary,rsk-method}}
}
\author{
Dan Kelley and Clark Richards
}
\concept{classes provided by oce}
\concept{things related to rsk data}
