% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\docType{methods}
\name{[[<-,adv-method}
\alias{[[<-,adv-method}
\title{Replace Parts of an ADV Object}
\usage{
\S4method{[[}{adv}(x, i, j, ...) <- value
}
\arguments{
\item{x}{An \code{adv} object, i.e. one inheriting from \code{\link{adv-class}}.}

\item{i}{Character string indicating the name of item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}

\item{value}{The value to be inserted into \code{x}.}
}
\description{
The \code{[[} method works for all \code{oce} objects, i.e.
objects inheriting from \code{\link{oce-class}}.  The purpose
is to insulate users from the internal details of \code{oce}
objects, by looking for items within the various storage
slots of the object. Items that are not actually stored in
the object can also be extracted, including derived data such
as potential temperature, the units of measurement for
the data, data-quality flags, etc.
}
\details{
If the \code{adv} object holds slow variables (i.e. if \code{timeSlow} is
in the \code{data} slot), then assigning to .e.g. \code{heading} will not
actually assign to a variable of that name, but instead assigns to
\code{headingSlow}. To catch misapplication of this rule, an error
message will be issued if the assigned value is not of the same length
as \code{timeSlow}.

A two-step process is used to try to find the
requested information. First, a class-specific function
tries to find it, but
if that fails, then a general function is used
(see next section).
}
\section{Details of the general method}{


If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges
first on the values of \code{i} and, optionally, \code{j}. The work
proceeds in steps, by testing a sequence of possible conditions
in sequence.

\enumerate{

\item A check is made as to whether \code{i} names one of the standard
\code{oce} slots. If so, \code{[[} returns the slot contents of that slot.
Thus, \code{x[["metadata"]]} will retrieve the \code{metadata} slot,
while \code{x[["data"]]} and \code{x[["processingLog"]]} return
those slots.

\item If \code{i} is a string ending in the
\code{"Unit"}, then the characters preceding that string
are taken to be the name of an item in the data object, and a list
containing the unit is returned. This list consists of an item
named \code{unit}, which is an \code{\link{expression}}, and
an item named \code{scale}, which is a string describing the
measurement scale.  If the string ends in \code{" unit"}, e.g.
\code{x[["temperature unit"]]} (note the space),
then just the expression is returned, and if it ends in
\code{" scale"}, then just the scale is returned.

\item If \code{i} is a string ending in \code{"Flag"}, then the corresponding
data-quality flag is returned (or \code{NULL} if there is no such flag).
For example, \code{x[["salinityFlag"]]} returns a vector of salinity
flags if \code{x} is a ctd object.

\item If \code{i} is \code{"sigmaTheta"}, then the value of
\code{\link{swSigmaTheta}(x)} is returned. Similarly,
\code{"sigma0"} returns \code{\link{swSigma0}(x)} and
\code{"spice"} returns \code{\link{swSpice}(x)}. Note that
these relate to seawater properties and only make sense for
certain object types.

\item After these possibilities are eliminated,
the action depends on whether \code{j} has been provided.
If \code{j} is not provided, or is the string \code{""},
then \code{i} is sought
in the \code{metadata} slot, and then in the \code{data} slot,
returning whichever is found first.  In other words, if \code{j}
is not provided, the \code{metadata} slot takes preference over
the \code{data} slot. However, if \code{j} is provided, then
it must be either the string \code{"metadata"} or \code{"data"},
and it directs where to look.
}

If none of the above-listed conditions holds, then \code{NULL} is returned,
without the issuance of a warning or error message. (This silent operation
is employed so that \code{[[} will behave like the normal R version.)
}

\seealso{
Other functions that extract parts of oce objects: \code{\link{[[,adp-method}},
  \code{\link{[[,adv-method}},
  \code{\link{[[,amsr-method}},
  \code{\link{[[,argo-method}},
  \code{\link{[[,bremen-method}},
  \code{\link{[[,cm-method}},
  \code{\link{[[,coastline-method}},
  \code{\link{[[,ctd-method}},
  \code{\link{[[,echosounder-method}},
  \code{\link{[[,g1sst-method}},
  \code{\link{[[,gps-method}},
  \code{\link{[[,ladp-method}},
  \code{\link{[[,landsat-method}},
  \code{\link{[[,lisst-method}},
  \code{\link{[[,lobo-method}},
  \code{\link{[[,met-method}}, \code{\link{[[,oce-method}},
  \code{\link{[[,odf-method}}, \code{\link{[[,rsk-method}},
  \code{\link{[[,sealevel-method}},
  \code{\link{[[,section-method}},
  \code{\link{[[,tidem-method}},
  \code{\link{[[,topo-method}},
  \code{\link{[[,windrose-method}}

Other things related to adv data: \code{\link{[[,adv-method}},
  \code{\link{adv-class}}, \code{\link{adv}},
  \code{\link{beamName}}, \code{\link{beamToXyz}},
  \code{\link{enuToOtherAdv}}, \code{\link{enuToOther}},
  \code{\link{plot,adv-method}},
  \code{\link{read.adv.nortek}},
  \code{\link{read.adv.sontek.adr}},
  \code{\link{read.adv.sontek.serial}},
  \code{\link{read.adv.sontek.text}},
  \code{\link{read.adv}}, \code{\link{rotateAboutZ}},
  \code{\link{subset,adv-method}},
  \code{\link{summary,adv-method}}, \code{\link{toEnuAdv}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdv}}, \code{\link{xyzToEnu}}
}
\author{
Dan Kelley
}
\concept{functions that extract parts of oce objects}
\concept{things related to adv data}
