% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\name{topoInterpolate}
\alias{topoInterpolate}
\title{Interpolate Within a Topo Object}
\usage{
topoInterpolate(longitude, latitude, topo)
}
\arguments{
\item{longitude}{Vector of longitudes (in the same sign convention as used in
\code{topo}).}

\item{latitude}{Vector of latitudes (in the same sign convention as used in
\code{topo}).}

\item{topo}{A \code{topo} object, i.e. inheriting from
\code{\link{topo-class}}.}
}
\value{
Vector of heights giving the elevation of the earth above means sea
level at the indicated location on the earth.
}
\description{
Bilinear interpolation is used so that values will vary smoothly within a
longitude-latitude grid cell. Note that the sign convention for
\code{longitude} and \code{latitude} must match that in \code{topo}.
}
\examples{
library(oce)
data(topoWorld)
# "The Gully", approx. 400m deep, connects Gulf of St Lawrence with North Atlantic
topoInterpolate(45, -57, topoWorld)

}
\seealso{
Other things related to topo data: \code{\link{[[,topo-method}},
  \code{\link{[[<-,topo-method}}, \code{\link{as.topo}},
  \code{\link{download.topo}},
  \code{\link{plot,topo-method}}, \code{\link{read.topo}},
  \code{\link{subset,topo-method}},
  \code{\link{summary,topo-method}},
  \code{\link{topo-class}}, \code{\link{topoWorld}}
}
\author{
Dan Kelley
}
\concept{things related to topo data}
