% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{ctdRepair}
\alias{ctdRepair}
\title{Repair a malformed ctd object}
\usage{
ctdRepair(x, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{a \linkS4class{ctd} object.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A \linkS4class{ctd} object that is based on \code{x}, but possibly
with some elements changed as described in the \dQuote{Details}
section.
}
\description{
Make a \linkS4class{ctd} object adhere more closely with the expected form, e.g. by
moving certain things from the \code{data} slot to the \code{metadata} slot, where
other oce functions may assume they will be located.
This can be handy for objects that were set up
incorrectly, perhaps by inappropriate user insertions.
}
\details{
The possible changes fall into the following categories.
\enumerate{
\item If unit-length values for \code{latitude}, \code{longitude}, \code{time}, or \code{station}
exist in the \code{data} slot, move them to the \code{metadata} slot.  However,
leave them in \code{data}  if their length exceeds 1, because this can
arise with towyo data.
\item If the \code{metadata} or \code{data} slot contains items named
\code{time}, \code{recoveryTime}, \code{startTime}, or \code{systemUploadTime},
and if these are not in POSIXt format, then use \code{\link[=as.POSIXct]{as.POSIXct()}} with
\code{tz="UTC"} to convert them to POSIXt format. If that conversion fails,
owing to an unrecognizable format, then the original value
is retained, unaltered.
}
}
\examples{
library(oce)
data(ctd)
# Insert location information into 'data', although it belongs in 'metadata'.
ctd@data$latitude <- ctd@metadata$latitude   # do NOT do this!
ctd@data$longitude <- ctd@metadata$longitude # do NOT do this!
repaired <- ctdRepair(ctd)

}
\seealso{
Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\author{
Dan Kelley
}
\concept{things related to ctd data}
