% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oce.plot.ts}
\alias{oce.plot.ts}
\title{Oce Variant of plot.ts}
\usage{
oce.plot.ts(
  x,
  y,
  type = "l",
  xlim,
  ylim,
  log = "",
  logStyle = "r",
  flipy = FALSE,
  xlab,
  ylab,
  drawTimeRange,
  simplify = 2560,
  fill = FALSE,
  col = par("col"),
  pch = par("pch"),
  cex = par("cex"),
  cex.axis = par("cex.axis"),
  cex.lab = par("cex.lab"),
  cex.main = par("cex.main"),
  xaxs = par("xaxs"),
  yaxs = par("yaxs"),
  mgp = getOption("oceMgp"),
  mar = c(mgp[1] + if (nchar(xlab) > 0) 1.5 else 1, mgp[1] + 1.5, mgp[2] + 1, mgp[2] +
    3/4),
  main = "",
  despike = FALSE,
  axes = TRUE,
  tformat,
  marginsAsImage = FALSE,
  grid = FALSE,
  grid.col = "lightgray",
  grid.lty = "dotted",
  grid.lwd = par("lwd"),
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{x}{the times of observations.  If this is not a \link{POSIXt} object, then an
attempt is made to convert it to one using \code{\link[=as.POSIXct]{as.POSIXct()}}.}

\item{y}{the observations.}

\item{type}{plot type, \code{"l"} for lines, \code{"p"} for points.}

\item{xlim}{optional limit for x axis.  This has an additional effect,
beyond that for conventional R functions: it effectively windows the data,
so that autoscaling will yield limits for y that make sense within the
window.}

\item{ylim}{optional limit for y axis.}

\item{log}{a character value that must be either empty (the default) for linear
\code{y} axis, or \code{"y"} for logarithmic \code{y} axis.  (Unlike
\code{\link[=plot.default]{plot.default()}} etc., \code{oce.plot.ts} does not permit
logarithmic time, or \code{x} axis.)}

\item{logStyle}{a character value that indicates how to draw the y axis, if
\code{log="y"}.  If it is \code{"r"} (the default) then the conventional R style is used,
in which a logarithmic transform connects y values to position on the "page"
of the plot device, so that tics will be nonlinearly spaced, but not
organized by integral powers of 10.  However, if it is \code{"decade"}, then
the style will be that used in the scientific literature, in which large
tick marks are used for integral powers of 10, with smaller tick marks
at integral multiples of those powers, and with labels that use exponential
format for values above 100 or below 0.01.  The value of \code{logStyle} is passed
to \code{\link[=oceAxis]{oceAxis()}}, which draws the axis.}

\item{flipy}{Logical, with \code{TRUE} indicating that the graph
should have the y axis reversed, i.e. with smaller values at
the bottom of the page.}

\item{xlab}{name for x axis; defaults to \code{""}.}

\item{ylab}{name for y axis; defaults to the plotted item.}

\item{drawTimeRange}{an optional indication of whether/how to draw a time range,
in the top-left margin of the plot; see \code{\link[=oce.axis.POSIXct]{oce.axis.POSIXct()}} for details.}

\item{simplify}{an integer value that indicates
whether to speed up \code{type="l"} plots by replacing the data
with minimum and maximum values within a subsampled time mesh.
This can speed up plots of large datasets (e.g. by factor 20 for 10^7 points),
sometimes with minor changes in appearance.
This procedure is skipped if \code{simplify} is \code{NA} or
if the number of visible data points is less than 5 times \code{simplify}.
Otherwise, \code{oce.plot.ts} creates \code{simplify} intervals ranging across
the visible time range. Intervals with under 2 finite
\code{y} data are ignored. In the rest, \code{y} values
are replaced with their range, and \code{x} values are replaced
with the repeated midpoint time. Thus, each retained sub-interval
has exactly 2 data points.
A warning is printed if this replacement is done.
The default value of \code{simplify} means that cases with
under 2560 visible points are plotted conventionally.}

\item{fill}{boolean, set \code{TRUE} to fill the curve to zero (which it
does incorrectly if there are missing values in \code{y}).}

\item{col}{The colours for points (if \code{type=="p"}) or lines (if \code{type=="l"}).
For the \code{type="p"} case,
if there are fewer \code{col} values than there are \code{x} values, then the \code{col} values
are recycled in the standard fashion.
For the \code{type="l"} case, the line is plotted in the first colour specified.}

\item{pch}{character code, used if \code{type=="p"}.
If there are fewer \code{pch} values than there are \code{x} values, then the \code{pch} values
are recycled in the standard fashion.
See \code{\link[=points]{points()}} for the possible values for \code{pch}.}

\item{cex}{numeric character expansion factor for points on plots, ignored unless
\code{type} is \code{"p"}.  This may be a single number, applied to all points, or
a vector of numbers to be applied to the points in sequence.  If there are
fewer \code{pch} values than there are \code{x} values, then the \code{pch} values are recycled
in the standard fashion. See \code{\link[=par]{par()}} for more on \code{cex}.}

\item{cex.axis, cex.lab, cex.main}{numeric character expansion factors for axis numbers,
axis names and plot titles; see \code{\link[=par]{par()}}.}

\item{xaxs}{control x axis ending; see \code{\link{par}}\code{("xaxs")}.}

\item{yaxs}{control y axis ending; see \code{\link{par}}\code{("yaxs")}.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also
for \code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}}\code{("mar")} to set margins.
The default value uses significantly tighter margins than is the norm in R,
which gives more space for the data.  However, in doing this, the existing
\code{par("mar")} value is ignored, which contradicts values that may have
been set by a previous call to \code{\link[=drawPalette]{drawPalette()}}.  To get plot with
a palette, first call \code{\link[=drawPalette]{drawPalette()}}, then call
\code{oce.plot.ts} with \code{mar=par("mar")}.}

\item{main}{title of plot.}

\item{despike}{boolean flag that can turn on despiking with
\code{\link[=despike]{despike()}}.}

\item{axes}{boolean, set to \code{TRUE} to get axes plotted}

\item{tformat}{optional format for labels on the time axis}

\item{marginsAsImage}{boolean indicating whether to set the right-hand
margin to the width normally taken by an image drawn with
\code{\link[=imagep]{imagep()}}.}

\item{grid}{if \code{TRUE}, a grid will be drawn for each panel.  (This
argument is needed, because calling \code{\link[=grid]{grid()}} after doing a
sequence of plots will not result in useful results for the individual
panels.}

\item{grid.col}{color of grid}

\item{grid.lty}{line type of grid}

\item{grid.lwd}{line width of grid}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}

\item{\dots}{graphical parameters passed down to \code{\link[=plot]{plot()}}.}
}
\value{
A list is silently returned, containing \code{xat} and \code{yat},
values that can be used by \code{\link[=oce.grid]{oce.grid()}} to add a grid to the plot.
}
\description{
Plot a time-series, obeying the timezone and possibly drawing the range in
the top-left margin.
}
\details{
Depending on the version of R, the standard \code{\link[=plot]{plot()}} and
\code{\link[=plot.ts]{plot.ts()}} routines will not obey the time zone of the data.
This routine gets around that problem.  It can also plot the time range in
the top-left margin, if desired; this string includes the timezone, to
remove any possible confusion.
The time axis is drawn with \code{\link[=oce.axis.POSIXct]{oce.axis.POSIXct()}}.
}
\examples{
library(oce)
t0 <- as.POSIXct("2008-01-01", tz="UTC")
t <- seq(t0, length.out=48, by="30 min")
y <- sin(as.numeric(t - t0) * 2 * pi / (12 * 3600))
oce.plot.ts(t, y, type='l', xaxs='i')
# Show how col, pch and cex get recycled
oce.plot.ts(t, y, type='p', xaxs='i',
            col=1:3, pch=c(rep(1, 6), rep(20, 6)), cex=sqrt(1:6))
# Trimming x; note the narrowing of the y view
oce.plot.ts(t, y, type='p', xlim=c(t[6], t[12]))
# Flip the y axis
oce.plot.ts(t, y, flipy=TRUE)
}
\author{
Dan Kelley and Clark Richards
}
