% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{GMTOffsetFromTz}
\alias{GMTOffsetFromTz}
\title{Determine Time Offset From Timezone}
\usage{
GMTOffsetFromTz(tz)
}
\arguments{
\item{tz}{a timezone, e.g. \code{UTC}.}
}
\value{
Number of hours in offset, e.g. \code{AST} yields 4.
}
\description{
The data are from
\verb{https://www.timeanddate.com/time/zones/} and were
hand-edited to develop this code, so there may be errors.  Also, note that
some of these contradict; if you examine the code, you'll see some
commented-out portions that represent solving conflicting definitions by
choosing the more common timezone abbreviation over a the less common one.
}
\examples{
library(oce)
cat("Atlantic Standard Time is ", GMTOffsetFromTz("AST"), "hours after UTC")
}
\author{
Dan Kelley
}
\concept{things relating to time}
