% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_to_odmatrix}
\alias{od_to_odmatrix}
\title{Convert origin-destination data from long to wide format}
\usage{
od_to_odmatrix(x, attrib = 3, name_orig = 1, name_dest = 2)
}
\arguments{
\item{x}{A data frame representing flows between origin and destinations}

\item{attrib}{A number or character string representing the column containing the attribute data
of interest from the \code{flow} data frame}

\item{name_orig}{A number or character string representing the zone of origin}

\item{name_dest}{A number or character string representing the zone of destination}
}
\description{
This function takes a data frame representing travel between origins
(with origin codes in \code{name_orig}, typically the 1st column)
and destinations
(with destination codes in \code{name_dest}, typically the second column) and returns a matrix
with cell values (from \code{attrib}, the third column by default) representing travel between
origins and destinations.
}
\examples{
x = od_data_df[1:4, ]
x_matrix = od_to_odmatrix(x)
class(x_matrix)
od_to_odmatrix(x, attrib = "bicycle")
}
\seealso{
Other od: 
\code{\link{od_id}},
\code{\link{odmatrix_to_od}()}
}
\concept{od}
