% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nestedSurvey.R
\name{mergeNestedODK}
\alias{mergeNestedODK}
\title{mergeNestedODK}
\usage{
mergeNestedODK(parent, child, byPARENT_KEY = TRUE, removeCols = NULL,
  removeRows = NULL)
}
\arguments{
\item{parent}{Data frame of household data}

\item{child}{Data frame of child (repeat) data}

\item{byPARENT_KEY}{Should data frames be matched based on PARENT_KEY (child)
and KEY (parent) columns? (Currently only option is TRUE)}

\item{removeCols}{Character vector of column names to remove from the parent
data frame (optional)}

\item{removeRows}{Index of which rows should be removed from child data frame
(optional)}
}
\value{
Merged dataframe
}
\description{
Retrieve parent data, matching to a nested (child) dataset by keys of a
nested dataset exported from an ODK Aggregate Server.
}
\examples{
# marge sampleData2 and sampleData3
x <- renameODK(sampleData2)
y <- renameODK(sampleData3)
temp <- mergeNestedODK(parent = x, child = y, byPARENT_KEY = FALSE)

}
