% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_density.R
\name{dmvnorm}
\alias{dmvnorm}
\title{Compute density of multivariate normal distribution}
\usage{
dmvnorm(x, mean, Sigma, log = FALSE)
}
\arguments{
\item{x}{A \code{numeric}, a quantile vector of length \code{p}.}

\item{mean}{A \code{numeric}, the mean vector of length \code{p}.}

\item{Sigma}{A \code{matrix}, the covariance matrix of dimension \code{p} x \code{p}.}

\item{log}{A \code{logical}, if \code{TRUE} the logarithm of the density value is
returned.
By default, \code{log = FALSE}.}
}
\value{
A \code{numeric}, the density value.
}
\description{
This function computes the density of a multivariate normal distribution.
}
\examples{
x <- c(0, 0)
mean <- c(0, 0)
Sigma <- diag(2)
dmvnorm(x = x, mean = mean, Sigma = Sigma)
dmvnorm(x = x, mean = mean, Sigma = Sigma, log = TRUE)

}
