% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.xval.oem}
\alias{predict.xval.oem}
\title{Prediction function for fitted cross validation oem objects}
\usage{
\method{predict}{xval.oem}(object, newx, which.model = "best.model",
  s = c("lambda.min", "lambda.1se"), ...)
}
\arguments{
\item{object}{fitted "cv.oem" model object}

\item{newx}{Matrix of new values for x at which predictions are to be made. Must be a matrix; can be sparse as in the 
\code{CsparseMatrix} objects of the \pkg{Matrix} package
This argument is not used for type=c("coefficients","nonzero")}

\item{which.model}{If multiple penalties are fit and returned in the same \code{oem} object, the \code{which.model} argument is used to 
specify which model to make predictions for. For example, if the oem object "oemobj" was fit with argument 
\code{penalty = c("lasso", "grp.lasso")}, then \code{which.model = 2} provides predictions for the group lasso model. For 
\code{predict.cv.oem()}, can specify
\code{"best.model"} to use the best model as estimated by cross-validation}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which predictions are required. Default is the entire sequence used to create 
the model. For predict.cv.oem, can also specify \code{"lambda.1se"} or \code{"lambda.min"} for best lambdas estimated by cross validation}

\item{...}{used to pass the other arguments for \code{predict.oem()}}
}
\value{
An object depending on the type argument
}
\description{
Prediction function for fitted cross validation oem objects
}
\examples{
set.seed(123)
n.obs <- 1e4
n.vars <- 100
n.obs.test <- 1e3

true.beta <- c(runif(15, -0.5, 0.5), rep(0, n.vars - 15))

x <- matrix(rnorm(n.obs * n.vars), n.obs, n.vars)
y <- rnorm(n.obs, sd = 3) + x \%*\% true.beta
x.test <- matrix(rnorm(n.obs.test * n.vars), n.obs.test, n.vars)
y.test <- rnorm(n.obs.test, sd = 3) + x.test \%*\% true.beta

fit <- xval.oem(x = x, y = y, 
                penalty = c("lasso", "grp.lasso"), 
                groups = rep(1:10, each = 10), 
                nlambda = 10)

preds.best <- predict(fit, newx = x.test, type = "response", which.model = "best.model")

apply(preds.best, 2, function(x) mean((y.test - x) ^ 2))

preds.gl <- predict(fit, newx = x.test, type = "response", which.model = "grp.lasso")

apply(preds.gl, 2, function(x) mean((y.test - x) ^ 2))

preds.l <- predict(fit, newx = x.test, type = "response", which.model = 1)

apply(preds.l, 2, function(x) mean((y.test - x) ^ 2))
}
