% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with_at.R
\name{ph_with_fpars_at}
\alias{ph_with_fpars_at}
\title{add multiple formated paragraphs}
\usage{
ph_with_fpars_at(x, fpars = list(), fp_pars = list(), left, top, width,
  height, bg = "transparent", rot = 0, template_type = NULL,
  template_index = 1)
}
\arguments{
\item{x}{rpptx object}

\item{fpars}{list of \code{\link{fpar}} objects}

\item{fp_pars}{list of \code{\link{fp_par}} objects. The list can contain
NULL to keep defaults.}

\item{left, top}{location of the new shape on the slide}

\item{width, height}{shape size in inches}

\item{bg}{background color}

\item{rot}{rotation angle}

\item{template_type}{placeholder template type. If used, the new shape will
inherit the style from the placeholder template. If not used, no text
property is defined and for example text lists will not be indented.}

\item{template_index}{placeholder template index (integer). To be used when a placeholder
template type is not unique in the current slide, e.g. two placeholders with
type 'body'.}
}
\description{
add several formated paragraphs in a new shape in the current slide.
}
\examples{

fileout <- tempfile(fileext = ".pptx")
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content",
  master = "Office Theme")

bold_face <- shortcuts$fp_bold(font.size = 0)
bold_redface <- update(bold_face, color = "red")

fpar_1 <- fpar(
  ftext("Hello ", prop = bold_face), ftext("World", prop = bold_redface ),
  ftext(", \\r\\nhow are you?", prop = bold_face ) )

fpar_2 <- fpar(
  ftext("Hello ", prop = bold_face), ftext("World", prop = bold_redface ),
  ftext(", \\r\\nhow are you again?", prop = bold_face ) )

doc <- ph_with_fpars_at(x = doc, fpars = list(fpar_1, fpar_2),
  fp_pars = list(NULL, fp_par(text.align = "center")),
  left = 1, top = 2, width = 7, height = 4)
doc <- ph_with_fpars_at(x = doc, fpars = list(fpar_1, fpar_2),
  template_type = "body", template_index = 1,
  left = 4, top = 5, width = 4, height = 3)

print(doc, target = fileout )
}
