% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf.R
\name{rtf_doc}
\alias{rtf_doc}
\title{Create an RTF document object}
\usage{
rtf_doc(
  def_sec = prop_section(),
  normal_par = fp_par(),
  normal_chunk = fp_text(font.family = "Arial", font.size = 11)
)
}
\arguments{
\item{def_sec}{a \link{block_section} object used to defined default section.}

\item{normal_par}{an object generated by \code{\link[=fp_par]{fp_par()}}}

\item{normal_chunk}{an object generated by \code{\link[=fp_text]{fp_text()}}}
}
\value{
an object of class \code{rtf} representing an
empty RTF document.
}
\description{
Creation of the object representing an
RTF document which can then receive contents with
the \code{\link[=rtf_add]{rtf_add()}} function and be written to a file with
the \code{print(x, target="doc.rtf")} function.
}
\examples{
rtf_doc(normal_par = fp_par(padding = 3))
}
\seealso{
\code{\link[=read_docx]{read_docx()}}, \code{\link[=print.rtf]{print.rtf()}}, \code{\link[=rtf_add]{rtf_add()}}
}
