% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_img}
\alias{body_add_img}
\title{Add an image in a 'Word' document}
\usage{
body_add_img(x, src, style = NULL, width, height, pos = "after", unit = "in")
}
\arguments{
\item{x}{an rdocx object}

\item{src}{image filename, the basename of the file must not contain any blank.}

\item{style}{paragraph style}

\item{width, height}{image size in units expressed by the unit argument.
Defaults to "in"ches.}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}

\item{unit}{One of the following units in which the width and height
arguments are expressed: "in", "cm" or "mm".}
}
\description{
add an image into an rdocx object.
}
\examples{
doc <- read_docx()

img.file <- file.path(R.home("doc"), "html", "logo.jpg")
if (file.exists(img.file)) {
  doc <- body_add_img(x = doc, src = img.file, height = 1.06, width = 1.39)

  # Set the unit in which the width and height arguments are expressed
  doc <- body_add_img(
    x = doc, src = img.file,
    height = 2.69, width = 3.53,
    unit = "cm"
  )
}

print(doc, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_caption}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_par}()},
\code{\link{body_add_plot}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()},
\code{\link{body_append_start_context}()},
\code{\link{body_import_docx}()}
}
\concept{functions for adding content}
