% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{show}
\alias{show}
\title{Show model information}
\usage{
show(
  name,
  verbose = FALSE,
  output = c("jsonlist", "resp", "raw"),
  endpoint = "/api/show",
  host = NULL
)
}
\arguments{
\item{name}{Name of the model to show}

\item{verbose}{Returns full data for verbose response fields. Default is FALSE.}

\item{output}{The output format. Default is "jsonlist". Other options are "resp", "raw".}

\item{endpoint}{The endpoint to show the model. Default is "/api/show".}

\item{host}{The base URL to use. Default is NULL, which uses Ollama's default base URL.}
}
\value{
A response in the format specified in the output parameter.
}
\description{
Model information includes details, modelfile, template, parameters, license, system prompt.
}
\examples{
\dontshow{if (test_connection()$status_code == 200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# show("llama3") # returns jsonlist
show("llama3", output = "resp") # returns response object
\dontshow{\}) # examplesIf}
}
\references{
\href{https://github.com/ollama/ollama/blob/main/docs/api.md#show-model-information}{API documentation}
}
