% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-added-variable-plot.R
\name{ols_avplots}
\alias{ols_avplots}
\title{Added Variable Plot}
\usage{
ols_avplots(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\description{
Added variable plot provides information about the marginal importance of a 
predictor variable, given the other predictor variables already in 
the model. It shows the marginal importance of the variable in reducing the
residual variability.
}
\details{
The added variable plot was introduced by Mosteller and Tukey (1977). It enables
us to visualize the regression coefficient of a new variable being considered to
be included in a model. The plot can be constructed for each predictor variable.

Let us assume we want to test the effect of adding/removing variable \emph{X} from a
model. Let the response variable of the model be \emph{Y}

Steps to construct an added variable plot:

\itemize{
  \item Regress \emph{Y} on all variables other than \emph{X} and store the residuals (\emph{Y} residuals).
  \item Regress \emph{X} on all the other variables included in the model (\emph{X} residuals).
  \item Construct a scatter plot of \emph{Y} residuals and \emph{X} residuals.
}

What do the \emph{Y} and \emph{X} residuals represent? The \emph{Y} residuals represent the part
of \strong{Y} not explained by all the variables other than X. The \emph{X} residuals
represent the part of \strong{X} not explained by other variables. The slope of the line
fitted to the points in the added variable plot is equal to the regression
coefficient when \strong{Y} is regressed on all variables including \strong{X}.

A strong linear relationship in the added variable plot indicates the increased
importance of the contribution of \strong{X} to the model already containing the
other predictors.
}
\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_avplots(model)
}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.

Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition). 
Chicago, IL., McGraw Hill/Irwin.
}

