% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-regression.R
\name{ols_stepwise}
\alias{ols_stepwise}
\alias{plot.ols_stepwise}
\title{Stepwise Regression}
\usage{
ols_stepwise(model, ...)

\method{plot}{ols_stepwise}(x, model = NA, ...)
}
\arguments{
\item{model}{an object of class \code{lm}; the model should include all candidate predictor variables}

\item{...}{other arguments}

\item{x}{an object of class \code{ols_stepwise}}
}
\value{
\code{ols_stepwise} returns an object of class \code{"ols_stepwise"}.
An object of class \code{"ols_stepwise"} is a list containing the
following components:

\item{orders}{f statistic}
\item{method}{f statistic}
\item{steps}{f statistic}
\item{predictors}{p value of \code{score}}
\item{rsquare}{degrees of freedom}
\item{aic}{fitted values of the regression model}
\item{sbc}{name of explanatory variables of fitted regression model}
\item{sbic}{response variable}
\item{adjr}{predictors}
\item{rmse}{predictors}
\item{mallows_cp}{predictors}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by entering and removing predictors based on 
p values, in a stepwise manner until there is no variable left to enter or remove any more.
}
\examples{
# stepwise regression
model <- lm(y ~ ., data = surgical)
ols_stepwise(model)

# stepwise regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_stepwise(model)
plot(k)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}

