% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-both-regression.R
\name{ols_stepaic_both}
\alias{ols_stepaic_both}
\alias{plot.ols_stepaic_both}
\title{Stepwise AIC Regression}
\usage{
ols_stepaic_both(model, details = FALSE)

\method{plot}{ols_stepaic_both}(x, ...)
}
\arguments{
\item{model}{an object of class \code{lm}}

\item{details}{logical; if \code{TRUE}, details of variable selection will be printed on screen}

\item{x}{an object of class \code{ols_stepaic_both}}

\item{...}{other arguments}
}
\value{
\code{ols_stepaic_both} returns an object of class \code{"ols_stepaic_both"}.
An object of class \code{"ols_stepaic_both"} is a list containing the
following components:

\item{predictors}{variables added/removed from the model}
\item{method}{addition/deletion}
\item{aics}{akaike information criteria}
\item{ess}{error sum of squares}
\item{rss}{regression sum of squares}
\item{rsq}{rsquare}
\item{arsq}{adjusted rsquare}
\item{steps}{total number of steps}
}
\description{
Build regression model from a set of candidate predictor variables by entering and removing predictors based on 
Akaike Information Criteria, in a stepwise manner until there is no variable left to enter or remove any more.
}
\examples{
# stepwise regression
model <- lm(y ~ ., data = surgical)
ols_stepaic_both(model)

# stepwise regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_stepaic_both(model)
plot(k)

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}

