% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-both-regression.R
\name{ols_step_both_aic}
\alias{ols_step_both_aic}
\alias{plot.ols_step_both_aic}
\alias{ols_stepaic_both}
\title{Stepwise AIC regression}
\usage{
ols_step_both_aic(model, details = FALSE)

\method{plot}{ols_step_both_aic}(x, ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{details}{Logical; if \code{TRUE}, details of variable selection will
be printed on screen.}

\item{x}{An object of class \code{ols_step_both_aic}.}

\item{...}{Other arguments.}
}
\value{
\code{ols_step_both_aic} returns an object of class \code{"ols_step_both_aic"}.
An object of class \code{"ols_step_both_aic"} is a list containing the
following components:

\item{predictors}{variables added/removed from the model}
\item{method}{addition/deletion}
\item{aics}{akaike information criteria}
\item{ess}{error sum of squares}
\item{rss}{regression sum of squares}
\item{rsq}{rsquare}
\item{arsq}{adjusted rsquare}
\item{steps}{total number of steps}
}
\description{
Build regression model from a set of candidate predictor variables by
entering and removing predictors based on akaike information criteria, in a
stepwise manner until there is no variable left to enter or remove any more.
}
\section{Deprecated Function}{

\code{ols_stepaic_both()} has been deprecated. Instead use \code{ols_step_both_aic()}.
}

\examples{
\dontrun{
# stepwise regression
model <- lm(y ~ ., data = stepdata)
ols_step_both_aic(model)
}

\dontrun{
# stepwise regression plot
model <- lm(y ~ ., data = stepdata)
k <- ols_step_both_aic(model)
plot(k)
}

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other variable selection procedures: \code{\link{ols_step_all_possible}},
  \code{\link{ols_step_backward_aic}},
  \code{\link{ols_step_backward_p}},
  \code{\link{ols_step_best_subset}},
  \code{\link{ols_step_forward_aic}},
  \code{\link{ols_step_forward_p}}
}
