% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-residual-fit-spread-plot.R
\name{ols_plot_resid_fit_spread}
\alias{ols_plot_resid_fit_spread}
\alias{ols_plot_fm}
\alias{ols_plot_resid_spread}
\alias{ols_rfs_plot}
\alias{ols_rsd_plot}
\alias{ols_fm_plot}
\title{Residual fit spread plot}
\usage{
ols_plot_resid_fit_spread(model, print_plot = TRUE)

ols_plot_fm(model, print_plot = TRUE)

ols_plot_resid_spread(model, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\description{
Plot to detect non-linearity, influential observations and outliers.
}
\details{
Consists of side-by-side quantile plots of the centered fit and the
residuals. It shows how much variation in the data is explained by the fit
and how much remains in the residuals. For inappropriate models, the spread
of the residuals in such a plot is often greater than the spread of the
centered fit.
}
\section{Deprecated Function}{

\code{ols_rfs_plot()}, \code{ols_fm_plot()} and \code{ols_rsd_plot()}
  has been deprecated. Instead use \code{ols_plot_resid_fit_spread()},
  \code{ols_plot_fm()} and \code{ols_plot_resid_spread()}.
}

\examples{
# model
model <- lm(mpg ~ disp + hp + wt, data = mtcars)

# residual fit spread plot
ols_plot_resid_fit_spread(model)

# fit mean plot
ols_plot_fm(model)

# residual spread plot
ols_plot_resid_spread(model)

}
\references{
Cleveland, W. S. (1993). Visualizing Data. Summit, NJ: Hobart Press.
}
