# output from stepwise forward regression is as expected

    Code
      ols_step_forward_p(model)
    Output
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                38202.426 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_p(model, progress = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. pindex 
      3. enzyme_test 
      4. liver_test 
      5. age 
      6. gender 
      7. alc_mod 
      8. alc_heavy 
      
      
      Variables Entered: 
      
      => liver_test 
      => alc_heavy 
      => enzyme_test 
      => pindex 
      => bcs 
      
      No more variables to be added.
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                38202.426 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_p(model, details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. pindex 
      3. enzyme_test 
      4. liver_test 
      5. age 
      6. gender 
      7. alc_mod 
      8. alc_heavy 
      
      
      Step   => 0 
      Model  => y ~ 1 
      R2     => 0 
      
      Initiating stepwise selection... 
      
                           Selection Metrics Table                      
      -----------------------------------------------------------------
      Predictor      Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      -----------------------------------------------------------------
      liver_test      0.00000        0.455             0.444    771.875 
      enzyme_test     0.00000        0.334             0.322    782.629 
      pindex          0.00155        0.177             0.161    794.100 
      alc_heavy       0.00172        0.174             0.158    794.301 
      bcs             0.01025        0.120             0.103    797.697 
      alc_mod         0.19286        0.032             0.014    802.828 
      gender          0.20972        0.030             0.011    802.956 
      age             0.39073        0.014            -0.005    803.834 
      -----------------------------------------------------------------
      
      Step      => 1 
      Selected  => liver_test 
      Model     => y ~ liver_test 
      R2        => 0.455 
      
                           Selection Metrics Table                      
      -----------------------------------------------------------------
      Predictor      Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      -----------------------------------------------------------------
      alc_heavy       0.00065        0.567             0.550    761.439 
      enzyme_test     0.00089        0.562             0.544    762.077 
      pindex          0.07087        0.489             0.469    770.387 
      alc_mod         0.10979        0.481             0.461    771.141 
      gender          0.79395        0.455             0.434    773.802 
      age             0.83908        0.455             0.434    773.831 
      bcs             0.93062        0.455             0.433    773.867 
      -----------------------------------------------------------------
      
      Step      => 2 
      Selected  => alc_heavy 
      Model     => y ~ liver_test + alc_heavy 
      R2        => 0.567 
      
                           Selection Metrics Table                      
      -----------------------------------------------------------------
      Predictor      Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      -----------------------------------------------------------------
      enzyme_test     0.00057        0.659             0.639    750.509 
      pindex          0.00961        0.622             0.599    756.125 
      bcs             0.55687        0.570             0.544    763.063 
      age             0.58269        0.569             0.544    763.110 
      alc_mod         0.91757        0.567             0.541    763.428 
      gender          0.93799        0.567             0.541    763.433 
      -----------------------------------------------------------------
      
      Step      => 3 
      Selected  => enzyme_test 
      Model     => y ~ liver_test + alc_heavy + enzyme_test 
      R2        => 0.659 
      
                          Selection Metrics Table                     
      ---------------------------------------------------------------
      Predictor    Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      ---------------------------------------------------------------
      pindex          1e-04        0.750             0.730    735.715 
      bcs           0.21294        0.670             0.643    750.782 
      alc_mod       0.75743        0.660             0.632    752.403 
      age           0.77290        0.660             0.632    752.416 
      gender        0.99197        0.659             0.631    752.509 
      ---------------------------------------------------------------
      
      Step      => 4 
      Selected  => pindex 
      Model     => y ~ liver_test + alc_heavy + enzyme_test + pindex 
      R2        => 0.75 
      
                          Selection Metrics Table                     
      ---------------------------------------------------------------
      Predictor    Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      ---------------------------------------------------------------
      bcs           0.01248        0.781             0.758    730.620 
      age           0.86220        0.750             0.724    737.680 
      gender        0.96390        0.750             0.724    737.712 
      alc_mod       0.97040        0.750             0.724    737.713 
      ---------------------------------------------------------------
      
      Step      => 5 
      Selected  => bcs 
      Model     => y ~ liver_test + alc_heavy + enzyme_test + pindex + bcs 
      R2        => 0.781 
      
                          Selection Metrics Table                     
      ---------------------------------------------------------------
      Predictor    Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      ---------------------------------------------------------------
      age           0.74164        0.781             0.754    732.494 
      gender        0.80666        0.781             0.753    732.551 
      alc_mod       0.94086        0.781             0.753    732.614 
      ---------------------------------------------------------------
      
      
      No more variables to be added.
      
      Variables Selected: 
      
      => liver_test 
      => alc_heavy 
      => enzyme_test 
      => pindex 
      => bcs 
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                38202.426 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

# output from stepwise forward hierarchical regression

    Code
      ols_step_forward_p(model, 0.1, hierarchical = TRUE)
    Output
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      bcs            797.697    803.664    640.655    0.12010    0.10318 
       2      alc_heavy      791.701    799.657    633.668    0.24119    0.21144 
       3      pindex         778.574    788.519    620.390    0.42659    0.39218 
       4      enzyme_test    730.924    742.858    579.087    0.77136    0.75269 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.878       RMSE                 188.249 
      R-Squared                 0.771       MSE                39053.801 
      Adj. R-Squared            0.753       Coef. Var             28.147 
      Pred R-Squared            0.695       AIC                  730.924 
      MAE                     140.619       SBC                  742.858 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6455884.265         4    1613971.066    41.327    0.0000 
      Residual      1913636.272        49      39053.801                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1334.424       180.589                 -7.389    0.000    -1697.332    -971.516 
              bcs       81.439        17.781        0.329     4.580    0.000       45.706     117.171 
        alc_heavy      312.777        72.341        0.309     4.324    0.000      167.402     458.152 
           pindex       10.131         1.622        0.431     6.246    0.000        6.871      13.390 
      enzyme_test       11.243         1.308        0.601     8.596    0.000        8.614      13.871 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_p(model, 0.1, hierarchical = TRUE, progress = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. alc_heavy 
      3. pindex 
      4. enzyme_test 
      5. liver_test 
      6. age 
      7. gender 
      8. alc_mod 
      
      
      Variables Entered: 
      
      => bcs 
      => alc_heavy 
      => pindex 
      => enzyme_test 
      
      No more variables to be added.
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      bcs            797.697    803.664    640.655    0.12010    0.10318 
       2      alc_heavy      791.701    799.657    633.668    0.24119    0.21144 
       3      pindex         778.574    788.519    620.390    0.42659    0.39218 
       4      enzyme_test    730.924    742.858    579.087    0.77136    0.75269 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.878       RMSE                 188.249 
      R-Squared                 0.771       MSE                39053.801 
      Adj. R-Squared            0.753       Coef. Var             28.147 
      Pred R-Squared            0.695       AIC                  730.924 
      MAE                     140.619       SBC                  742.858 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6455884.265         4    1613971.066    41.327    0.0000 
      Residual      1913636.272        49      39053.801                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1334.424       180.589                 -7.389    0.000    -1697.332    -971.516 
              bcs       81.439        17.781        0.329     4.580    0.000       45.706     117.171 
        alc_heavy      312.777        72.341        0.309     4.324    0.000      167.402     458.152 
           pindex       10.131         1.622        0.431     6.246    0.000        6.871      13.390 
      enzyme_test       11.243         1.308        0.601     8.596    0.000        8.614      13.871 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_p(model, 0.1, hierarchical = TRUE, details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. alc_heavy 
      3. pindex 
      4. enzyme_test 
      5. liver_test 
      6. age 
      7. gender 
      8. alc_mod 
      
      
      Step   => 0 
      Model  => y ~ 1 
      R2     => 0 
      
      Initiating stepwise selection... 
      
                          Selection Metrics Table                     
      ---------------------------------------------------------------
      Predictor    Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      ---------------------------------------------------------------
      bcs           0.01025        0.120             0.103    797.697 
      ---------------------------------------------------------------
      
      Step      => 1 
      Selected  => bcs 
      Model     => y ~ bcs 
      R2        => 0.12 
      
                          Selection Metrics Table                     
      ---------------------------------------------------------------
      Predictor    Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      ---------------------------------------------------------------
      alc_heavy     0.00624        0.241             0.211    791.701 
      bcs           0.01025        0.120             0.103    797.697 
      ---------------------------------------------------------------
      
      Step      => 2 
      Selected  => alc_heavy 
      Model     => y ~ bcs + alc_heavy 
      R2        => 0.241 
      
                          Selection Metrics Table                     
      ---------------------------------------------------------------
      Predictor    Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      ---------------------------------------------------------------
      pindex          2e-04        0.427             0.392    778.574 
      alc_heavy     0.00624        0.241             0.211    791.701 
      bcs           0.01025        0.120             0.103    797.697 
      ---------------------------------------------------------------
      
      Step      => 3 
      Selected  => pindex 
      Model     => y ~ bcs + alc_heavy + pindex 
      R2        => 0.427 
      
                           Selection Metrics Table                      
      -----------------------------------------------------------------
      Predictor      Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      -----------------------------------------------------------------
      enzyme_test     0.00000        0.771             0.753    730.924 
      pindex            2e-04        0.427             0.392    778.574 
      alc_heavy       0.00624        0.241             0.211    791.701 
      bcs             0.01025        0.120             0.103    797.697 
      -----------------------------------------------------------------
      
      Step      => 4 
      Selected  => enzyme_test 
      Model     => y ~ bcs + alc_heavy + pindex + enzyme_test 
      R2        => 0.771 
      
                           Selection Metrics Table                      
      -----------------------------------------------------------------
      Predictor      Pr(>|t|)    R-Squared    Adj. R-Squared      AIC   
      -----------------------------------------------------------------
      enzyme_test     0.00000        0.771             0.753    730.924 
      pindex            2e-04        0.427             0.392    778.574 
      alc_heavy       0.00624        0.241             0.211    791.701 
      bcs             0.01025        0.120             0.103    797.697 
      liver_test      0.15457        0.781             0.758    730.620 
      -----------------------------------------------------------------
      
      
      Variables Selected: 
      
      => bcs 
      => alc_heavy 
      => pindex 
      => enzyme_test 
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      bcs            797.697    803.664    640.655    0.12010    0.10318 
       2      alc_heavy      791.701    799.657    633.668    0.24119    0.21144 
       3      pindex         778.574    788.519    620.390    0.42659    0.39218 
       4      enzyme_test    730.924    742.858    579.087    0.77136    0.75269 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.878       RMSE                 188.249 
      R-Squared                 0.771       MSE                39053.801 
      Adj. R-Squared            0.753       Coef. Var             28.147 
      Pred R-Squared            0.695       AIC                  730.924 
      MAE                     140.619       SBC                  742.858 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6455884.265         4    1613971.066    41.327    0.0000 
      Residual      1913636.272        49      39053.801                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1334.424       180.589                 -7.389    0.000    -1697.332    -971.516 
              bcs       81.439        17.781        0.329     4.580    0.000       45.706     117.171 
        alc_heavy      312.777        72.341        0.309     4.324    0.000      167.402     458.152 
           pindex       10.131         1.622        0.431     6.246    0.000        6.871      13.390 
      enzyme_test       11.243         1.308        0.601     8.596    0.000        8.614      13.871 
      ------------------------------------------------------------------------------------------------
      

