% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classCohortTable.R
\name{checkCohortRequirements}
\alias{checkCohortRequirements}
\title{Check whether a cohort table satisfies requirements}
\usage{
checkCohortRequirements(
  cohort,
  checkEndAfterStart = TRUE,
  checkOverlappingEntries = TRUE,
  checkMissingValues = TRUE,
  checkInObservation = TRUE,
  type = "error",
  call = parent.frame()
)
}
\arguments{
\item{cohort}{\code{cohort_table} object.}

\item{checkEndAfterStart}{If TRUE a check that all cohort end dates come on or
after cohort start date will be performed.}

\item{checkOverlappingEntries}{If TRUE a check that no individuals have overlapping
cohort entries will be performed.}

\item{checkMissingValues}{If TRUE a check that there are no missing values in
required fields will be performed.}

\item{checkInObservation}{If TRUE a check that cohort entries are within
the individuals observation periods will be performed.}

\item{type}{Can be either "error" or "warning". If "error" any check
failure will result in an error, whereas if "warning" any check failure
will result in a warning.}

\item{call}{The call for which to return the error message.}
}
\value{
An error will be returned if any of the selected checks fail.
}
\description{
Check whether a cohort table satisfies requirements
}
\examples{
\donttest{
library(omopgenerics)
person <- dplyr::tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- dplyr::tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2025-12-31"),
  period_type_concept_id = 0
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "test"
)
cdm <- insertTable(cdm, name = "cohort1", table = dplyr::tibble(
  cohort_definition_id = 1, subject_id = 1,
  cohort_start_date = as.Date(c("2020-01-01", "2020-01-10")),
  cohort_end_date = as.Date(c("2020-01-10", "2020-01-25"))
))
cdm$cohort1 <- newCohortTable(cdm$cohort1, .softValidation = TRUE)
# checkCohortRequirements(cdm$cohort1)
}
}
