% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-api.R
\name{objective_function}
\alias{objective_function}
\title{Extract the objective function from a model}
\usage{
objective_function(model)
}
\arguments{
\item{model}{the model}
}
\value{
a list with two named elements, 'solution' and 'constant'.
'solution' is a vector with a coefficient for each model variable.
'constant' is a constant that needs to be added to get the final obj. value.
}
\description{
Extract the objective function from a model
}
\examples{
library(magrittr)
model <- MIPModel() \%>\%
  add_variable(x[i], i = 1:5) \%>\%
  set_objective(sum_expr(i * x[i], i = 1:5) + 10)
objective_function(model)
}
