% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_plot_functions.R
\name{plot_rf_PCA}
\alias{plot_rf_PCA}
\title{plot_rf_PCA}
\usage{
plot_rf_PCA(rf_list, color, size, ellipse = FALSE, label = FALSE)
}
\arguments{
\item{rf_list}{The output from the random_forest function. This only works on classification models.}

\item{color}{A grouping factor. Use the one that was the LHS of your model parameter in the random_forest funciton}

\item{size}{The number for point size in the plot}

\item{ellipse}{TRUE or FALSE. Whether to plot with confidence interval ellipses or not.}

\item{label}{TRUE or FALSE. Whether to include point labels or not.}
}
\description{
PCA plot of the proximity matrix from a random forest classification model
}
\examples{
rf_list <- random_forest(c57_nos2KO_mouse_countDF,c57_nos2KO_mouse_metadata,
Treatment ~.,c(60,40),500)
plot_rf_PCA(rf_list = rf_list, color = "Treatment", size = 1.5)
}
