% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_negbin.R
\name{E_negbin}
\alias{E_negbin}
\title{Expected Value for One-Inflated Zero-Truncated Negative Binomial Distribution}
\usage{
E_negbin(b, g, a, X, Z)
}
\arguments{
\item{b}{Numeric vector of coefficients for the main model.}

\item{g}{Numeric vector of coefficients for the one-inflation process.}

\item{a}{Numeric scalar, the overdispersion parameter of the negative binomial distribution.}

\item{X}{Matrix of predictors for the main model, where rows correspond to observations
and columns to covariates.}

\item{Z}{Matrix of predictors for the one-inflation process, structured similarly to \code{X}.}
}
\value{
A numeric vector of expected values for each observation in the dataset.
}
\description{
Computes the expected value from a one-inflated, zero-truncated negative binomial (OIZTNB) distribution.
This function calculates the expected value based on the model parameters and covariates.
}
\seealso{
\code{\link{dEdq_nb}} for computing partial derivatives of expected values in the OIZTNB model.
}
\keyword{internal}
