\name{example_out}
\docType{data}
\alias{example_out}
\title{Data from a full-sib family derived from two outbred parents}
\description{
  Simulated data set for an outcross, i.e., an F1 population obtained by
  crossing two heterozygous parents.
}  
\usage{data(example_out)}
\format{
  An object of class \code{outcross}. 
}
\details{
  A total of 100 F1 individuals were genotyped for 30 markers.  The data
  currently contains only genotype information (no phenotypes).
}
\examples{
data(example_out)

# perform two-point analyses
twopts <- est.rf.2pts(example_out)
twopts
}
\author{Gabriel R A Margarido, \email{gramarga@esalq.usp.br}}
\seealso{
  \code{\link[onemap]{read.outcross}} for details about objects of class
  \code{outcross}.
}
\keyword{datasets}
