% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getse.R
\name{getse}
\alias{getse}
\title{Getting subelement from list.}
\usage{
getse(L, inm = NA, depth = 2, useregex = FALSE, fun = NA)
}
\arguments{
\item{L}{The list to get sub elements from.}

\item{inm}{Either an integer index or a name of the subelements to return.}

\item{depth}{The depth of the subelements to match names in:
- 1: is directly in the list.
- 2: is in list of each element in the list.
- 3 and more: simply deeper in the sublists.}

\item{useregex}{logical: should inm be used as regex pattern for returning elements matching, in the specified layer.}

\item{fun}{function: if given, then it will be applied to all the matched subelements before returning them.}
}
\value{
A list of the matched elements.
}
\description{
A helping function for getting subelemlts from a list.
}
\details{
Often it is needed to get a subelement from a list, which can be done using lapply.
But to make life easiere here is a small function for getting subelements in a nested list at a certain debth.
}
\examples{
# Make a nested list
L <- list(x1=list(x=list("val11","val112"),
                  y=list("val12"),
                  test=list("testlist2")),
          x2=list(x=list("val21","val212"),
                  y=list("val22"),
                  test=list("testlist2")),
          x3=list(x=list("val31","val312"),
                  y=list("val32"),
                  test=list("testlist3")))

# Get the subelement "x1"
str(getse(L, "x1", depth=1))
# Same as
str(L[["x1"]])

# Get the element named x in second layer
str(getse(L, "x", depth=2))
# Depth is default to 2
str(getse(L, "y"))

# Nice when splitting string
x <- strsplit(c("x.k1","y.k2"), "\\\\.")
# Get all before the split "\\."
getse(x, 1)
# Get after
getse(x, 2)

# Get an element with an integer index
x <- strsplit(c("x.k1","y.k2","x2"), "\\\\.")
getse(x, 1)
# if the element is not there, then an error is thrown
try(getse(x, 2))

# Use regex pattern for returning elements matching in the specified layer
getse(L, "^te", depth=2, useregex=TRUE)

}
