% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_term_sim_mat}
\alias{get_term_sim_mat}
\title{Get term-term similarity matrix}
\usage{
get_term_sim_mat(ontology, information_content,
  term_descendancy_matrix = get_term_descendancy_matrix(ontology, rows =
  get_ancestors(ontology, restrict_rows_to), cols = names(information_content)),
  method = c("lin", "resnik"),
  restrict_rows_to = names(information_content))
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{information_content}{Numeric vector of information contents of terms (named by term)}

\item{term_descendancy_matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO.}

\item{method}{Character vector - either "lin" (to use Lin's expression of similarity of terms) or "resnik" (to use Resnik's definition)}

\item{restrict_rows_to}{Restrict rows to Character vector of term names for which to compute corresponding similarities to all terms \code{information_content}}
}
\value{
Numeric matrix of term-term simliarities
}
\description{
Get term-term similarity matrix
}
\seealso{
\code{\link{resnik}}, \code{\link{lin}}
}

