% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.admin.r
\name{oadmin.install_package}
\alias{oadmin.install_package}
\title{Install package}
\usage{
oadmin.install_package(opal, pkg, repos = NULL)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{pkg}{Package name.}

\item{repos}{Character vector, the base URLs of the repositories to use.}
}
\value{
TRUE if successfully installed
}
\description{
Install package if not already available in Opal(s). To install the latest version of a package, it has to be removed first.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
oadmin.install_package(o, 'xxx')
opal.logout(o)
}
}
\seealso{
Other administration functions: 
\code{\link{oadmin.install_bioconductor_package}()},
\code{\link{oadmin.install_devtools}()},
\code{\link{oadmin.install_github_package}()},
\code{\link{oadmin.install_github}()},
\code{\link{oadmin.install_local_package}()},
\code{\link{oadmin.installed_devtools}()},
\code{\link{oadmin.installed_packages}()},
\code{\link{oadmin.installed_package}()},
\code{\link{oadmin.package_description}()},
\code{\link{oadmin.remove_package}()}
}
\concept{administration functions}
